#include <iostream>
#include <fstream>
#include <string>
#include <unistd.h>

int spl_cnt = 0;
int cnt = 8;

constexpr const char* tab = "	";

void clear_screen(){
using namespace std;
	cout << "\033[H\033[2J\033[3J";
}


constexpr const char* spl[6] =
	{
	"███████╗██╗  ██╗███████╗██████╗ \n",
	"██╔════╝██║ ██╔╝██╔════╝██╔══██╗\n",
	"███████╗█████╔╝ █████╗  ██║  ██║\n",
	"╚════██║██╔═██╗ ██╔══╝  ██║  ██║\n",
	"███████║██║  ██╗███████╗██████╔╝\n",
	"╚══════╝╚═╝  ╚═╝╚══════╝╚═════╝ \n"
	};

void print_tabs(int cnt) {
using namespace std;
    for (int i = 0; i < cnt; ++i) {
        cout << tab;
    }
}


void splash(){
	using namespace std;
	spl_cnt = 0;
	while(spl_cnt < 6){
		cout << spl[spl_cnt];
		spl_cnt = spl_cnt + 1;
	}
}

void splash_animate(){
using namespace std;
        while(cnt > 0){
                clear_screen();
                while(spl_cnt < 5){
                        print_tabs(cnt);
                        cout << spl[spl_cnt];
                        spl_cnt = spl_cnt + 1;
                }
                spl_cnt = 0;
                cnt = cnt - 1;
                usleep(20000);
        }
}

void splash_animate_2(){
        using namespace std;
        spl_cnt = 0;
        while(spl_cnt < 6){
                cout << spl[spl_cnt];
                spl_cnt = spl_cnt + 1;
        	usleep(60000);
	}
}



int main(int argc, char* argv[]) {
clear_screen();
splash_animate();
clear_screen();
splash();

    if (argc != 2) {
        std::cerr << "Usage: ./mycat <process_id>\n";
        return 1;
    }

    std::string pid = argv[1];
    std::string path = "/proc/" + pid + "/sched";

    std::ifstream sched_file(path);
    if (!sched_file.is_open()) {
        std::cerr << "Failed to open: " << path << "\n";
        return 1;
    }

    std::string line;
    while (std::getline(sched_file, line)) {
        std::cout << line << '\n';
    }

    sched_file.close();
    return 0;
}
