       IDENTIFICATION DIVISION.
       PROGRAM-ID. StormPressure.

       ENVIRONMENT DIVISION.

       DATA DIVISION.
       WORKING-STORAGE SECTION.
       01 Elevation-Feet             PIC 9(5)V99.
       01 Elevation-Meters           PIC 9(5)V99.
       01 Pressure                   PIC 9(6)V99.
       01 Normal-Temperature-Pressure PIC 9(6)V99 VALUE 101325.
       01 Kpa                        PIC 9(5)V99.
       01 InHg                       PIC 9(5)V99.

       PROCEDURE DIVISION.
       Main-Logic.
           DISPLAY "---- ---- ---- ----".
           DISPLAY "storm".
           DISPLAY "---- ---- ---- ----".
           DISPLAY "Enter elevation in feet: ".
           ACCEPT Elevation-Feet.

           COMPUTE Elevation-Meters = Elevation-Feet * 0.3048

           COMPUTE Pressure = Normal-Temperature-Pressure *
               FUNCTION EXP(FUNCTION LOG(1 - (2.25577E-5 * Elevation-Meters)) * 5.25588)

           COMPUTE Kpa = Pressure * 0.001
           DISPLAY Kpa " kPa"

           COMPUTE InHg = Kpa * 0.2953
           DISPLAY InHg " inHg"


           STOP RUN.
