#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include "utils.h"

const char* getTypeSuffix(const char* name) {
    static char suffix[2]; // one char + null terminator
    struct stat st;

    if (stat(name, &st) == -1) {
        // If stat fails, return empty string
        return "";
    }

    if (S_ISDIR(st.st_mode)) {
        suffix[0] = '/';
        suffix[1] = '\0';
        return suffix;
    }

    if (st.st_mode & S_IXUSR) {
        suffix[0] = '*';
        suffix[1] = '\0';
        return suffix;
    }

    return "";
}

int compareStrings(const void* a, const void* b) {
    const char* s1 = *(const char**)a;
    const char* s2 = *(const char**)b;
    return strcmp(s1, s2);
}
