#include <stdio.h>

int value, result, shift_amount;
char shift;

void clear_screen(){
        printf("\033[H\033[2J\033[3J");
}

void print_divi(){
        printf("---- ---- ---- ----\n");
}

void get_value() {
    printf("Enter value: ");
}

void get_shift() {
    printf("Shift direction (L/R): ");
}

void get_shift_amount() {
    printf("Enter shift amount: ");
}

void shift_right() {
    result = value >> shift_amount;
}

void shift_left() {
    result = value << shift_amount;
}

void print_binary(unsigned short n) {
    // Force 16-bit output
    for (int i = 15; i >= 0; i--) {
        unsigned short mask = 1u << i;
        putchar((n & mask) ? '1' : '0');
    }
    putchar('\n');
}

void print_result() {
        printf("Result:		%d\n", result);

        printf("		0x%X\n", result);

         printf("		0b");
    print_binary(result);
}

void print_value() {
    printf("Value:		%d\n", value);
    printf("		0x%X\n", value);
    printf("		0b");
    print_binary(value);
}


int main() {
    get_value();
    scanf("%d", &value);
    print_value();

    get_shift();
    scanf(" %c", &shift);  // space before %c skips whitespace

    get_shift_amount();
    scanf("%d", &shift_amount);

    if (shift == 'L' || shift == 'l') {
        shift_left();
    } else if (shift == 'R' || shift == 'r') {
        shift_right();
    } else {
        printf("Invalid shift direction: %c\n", shift);
        return 1;
    }
        clear_screen();
        printf("Shift\n");
        printf("Direction:      %c\n", shift);
        printf("Amount:         %d\n", shift_amount);
        print_divi();
        print_value();
        print_divi();
    print_result();
    return 0;
}
