#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <fcntl.h>

int is_host_online(const char *ip, int port, int timeout_ms) {
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) return 0;

    // Make socket non-blocking
    fcntl(sock, F_SETFL, O_NONBLOCK);

    struct sockaddr_in addr;
    memset(&addr, 0, sizeof(addr));
    addr.sin_family = AF_INET;
    addr.sin_port = htons(port);
    inet_pton(AF_INET, ip, &addr.sin_addr);

    int result = connect(sock, (struct sockaddr *)&addr, sizeof(addr));
    if (result < 0) {
        fd_set write_set;
        FD_ZERO(&write_set);
        FD_SET(sock, &write_set);

        struct timeval timeout;
        timeout.tv_sec = timeout_ms / 1000;
        timeout.tv_usec = (timeout_ms % 1000) * 1000;

        result = select(sock + 1, NULL, &write_set, NULL, &timeout);
        if (result > 0) {
            int err = 0;
            socklen_t len = sizeof(err);
            getsockopt(sock, SOL_SOCKET, SO_ERROR, &err, &len);
            close(sock);
            return err == 0;
        }
        close(sock);
        return 0;
    }

    close(sock);
    return 1;
}

int main() {
    const char *ips[] = {
        "192.168.0.174",
        "192.168.0.80",
        "192.168.0.113",
    };

    int count = sizeof(ips) / sizeof(ips[0]);

    for (int i = 0; i < count; i++) {
        int online = is_host_online(ips[i], 22, 1000);
        printf("%s -> %s\n", ips[i], online ? "ONLINE" : "OFFLINE");
    }

    return 0;
}
