#include <stdio.h>
#include <stdint.h>  // for uint64_t
#include <inttypes.h>

uint64_t pins;
uint64_t result;

void get_pins() {
    scanf("%" SCNu64, &pins);   // SCNu64 is the portable scanf macro for uint64_t
}

void calc_addr(uint64_t p) {
    result = (1ULL << p) - 1;   // 1ULL ensures 64-bit shift
}

void prompt_pins() {
    printf("Enter number of address pins: ");
}

void print_result() {
    printf("Highest address: %" PRIu64 "\n", result); // PRIu64 is the portable printf macro
}

int main() {
    prompt_pins();
    get_pins();
    calc_addr(pins);
    print_result();
    return 0;
}
