org 0xnnnn

LOAD_PROGRAM:
        LD HL, 0xnnnn                           ;SOURCE ADDRESS IN ROM
        LD DE, 0xnnnn                           ;DESTINATION ADDRESS IN RAM
        LD BC, 0xnn                           ;NUMBER OF BYTES TO COPY

COPY_LOOP:
        LD A, (HL)                              ;LOAD BYTE FROM ROM
        LD (DE), A                              ;STORE BYTE IN RAM
        INC HL                                  ;INCREMENT SOURCE ADDRESS
        INC DE                                  ;INCREMENT DESTINATION ADDRESS
        DEC BC                                  ;DECREMENT COUNTER
        LD A, B
        OR C
        JR NZ, COPY_LOOP                        ;REPEAT UNTIL BC IS ZERO

        ;STEP 3: JUMP TO PROGRAM
        XOR A
        LD (0xnnnn), A
        JP POLL_LOOP                               ;JUMP TO THE LOADED PROGRAM'S START ADDRESS

        ;END OF PROGRAM LOADER

CK_FD:

