.equ 	GPIOA_BASE, 0x40010800			; Base address of GPIOA
.equ	GPIO_CRL, 0x00				; Control Register Low
.equ	GPIOA_IDR, 0x08				; Input Data Register

.equ	MODE_INPUT, 0x4				; Input mode config (CNF=0, MODE=00)

.section .text
.global .start

; read from PA0 (GPIO pin 0)
_start:
	; Step 1: Configure PA0 as input
	li 	t0, GPIOA_BASE			; Load GPIOA base address
	lw 	t1, 0(t0)			; Load GPIOA_CRL
	andi 	t1, t1, 0xFFFFFF0F		; Clear bits for PA1 (bits 4-7)
	sw 	t1, 0(t0)			; Store updated GPIOA_CRL

	; Step 2: Read PA0 input value
	lw 	t2, GPIOA_IDR(t0)		; Load input data register
	andi	t2, t2, 0x2			; Mask PA1 bit (0b10)
	srli	t2, t2, 1			; Shift right 1 for PA1 bit position in GPIOA_IDR
	la	t3, value_store			; Load address to store the value
	sw	t2, 0(t3)			; Store the value in memory

	; End of program (loop forever)
loop:
	j loop

.section .bss
value_store: .word 0				; Memory location to store PA0 value
