; General GPIO read function

.equ	GPIOA_BASE, 0x40010800		; Base address of GPIOA
.equ	GPIO_CRL, 0x00			; Control Register Low
.equ	GPIO_IDR, 0x08			; Input Data Register

.section .text
.global read_gpio_pin

; |=====================================================================|
; |	Function: read_gpio_pin						|
; |	Arguements:							|
; |		a0 = Pin number (0-7)					|
; |	 Returns:							|
; |		a0 = 1 if HIGH, 0 if LOW				|
; |=====================================================================|

read_gpio_pin:
	li	t0, GPIOA_BASE		; Load GPIOA base address
	lw	t1, GPIOA_IDR(t0)	; Load GPIOA input data register
	li	t2, 1			; Load bitmask (1)
	sll	t2, t2, a0		; Shift 1 left by pin number
	and	a0, t1, t2		; Mask the desired bit
	snez	a0, a0			; Convert to 0 or 1
	ret				; Return result in a0

; |=====================================================================|
; |	Example usage:							|
; |		li	a0, 1			; Load pin number	|
; |		jal	ra, read_gpio_pin	; Call function		|
; |	a0 now holds the value (0 or 1)					|
; |=====================================================================|
